//
//  MCPGenericObject.h
//  MCPersistence
//
//  Created by aj on Tue Dec 25 2001.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "MCPObject.h"

@class MCPEntity;
@class MCPObjectContext;



@interface MCPGenericObject : MCPObject {
	NSMutableDictionary			*_storage;
	
}


// takes the ownership of the rawRow -- does not copy!!
- (void)takeRawRow:(NSMutableDictionary *)dict;
- (NSDictionary *)rawRow;

- (void)resetPrimaryKeys;

	

- (id)storedValueForAttribute:(NSString *)key;
- (void)takeStoredValue:(id)aValue forAttribute:(NSString *)key;
- (void)removeStoredValue:(id)aValue forAttribute:(NSString *)key;

//- (id)takeStoredValue:(id)aValue forPlainAttribute:(NSString *)key;
//- (id)takeStoredValue:(id)aValue forRelationshipAttribute:(NSString *)key;

/*
MCAttribute conformance -- Declared as NSObject category in MCFoundation
*/

- valueForAttribute:(NSString *)anAttribute;
- (void)genericObjectSetValue:aValue forAttribute:(NSString *)anAttribute;
- (id)genericObjectValueForKey:(NSString *)aKey;

- (void)_setStorageObject:(id)anObj forKey:(NSString *)aKey;
- (void)_removeStorageObject:(id)anObj forArrayKey:(NSString *)aKey;
- (void)_addStorageObject:(id)anObj forArrayKey:(NSString *)aKey;


- (void)addObject:object toRelationshipWithKey:(NSString *)key;
- (void)removeObject:object fromRelationshipWithKey:(NSString *)key;




@end
